<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");


session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 
?>




<main>
    <div class="container-fluid px-4">
        <div class="heading-contianer d-flex justify-content-between align-items-center">
            <div class="page-details">
                <h1 class="mt-4 dash-heading">User</h1>
                <ol class="breadcrumb mb-4">
                    <li class="breadcrumb-item active">User / Edit</li>
                </ol>
            </div>
            <a href="users.php" class="back-btn">Go Back</a>
        </div>


        <div class="user-edit-container">
            <?php 
        
        if (isset($_GET['user_id'])):
         $user_id = filter($_GET['user_id']);
        
        
        
        ?>
            <div class="row g-3">
                <div class="col-4">
                    <div class="user-data-view">
                        <div class="card-heading">
                            Edit - User
                        </div>
                        <?php 
                    
                    $sql = "SELECT * FROM `users` WHERE `id`=$user_id";
                    $query_run = mysqli_query($conn, $sql);
                    
                    if ($query_run):
                    
                        foreach ($query_run as $row):

                       
                    ?>
                        <div class="user-data-container d-flex justify-content-between flex-wrap">
                            <div class="user-imgage">
                                <img style="width: 100px; height: 100px;" src="<?= $row['avatar']; ?>" alt="avatar">
                                <div class="level-container">
                                    <?php
                                $levelId = $row['levelId'];
                                $getUserLevel= "SELECT `name`, `icon` FROM `earninglevels` WHERE `id` = $levelId LIMIT 1";
                                
                                $query_user_level_run = mysqli_query($conn, $getUserLevel);

                                foreach ($query_user_level_run as $key ):
?>

                                    <img style="width: 50px; height: 50px;" src="<?= $key['icon'];  ?>"
                                        alt="levelBadge">
                                    <span class="levelId">
                                        <?= $key['name']; ?>
                                    </span>
                                    <?php
                                endforeach;



                                ?>
                                </div>
                                <div class="user-stats">
                                    <p>User Stats</p>
                                    <p>Staus
                                        <?php
                                    if ($row['isBanned'] == 0) {
                                        echo "Active";
                                    } else{
                                        echo "Banned";
                                    }
                                ?>
                                    </p>
                                    <p>Quiz Played
                                        <?= filter($row['quizPlayed'])?>
                                    </p>
                                    <p>Invite Code
                                        <?= filter($row['inviteCode']);?>
                                    </p>
                                    <p>Invited By
                                        <?= filter($row['invitedBy']); ?>
                                    </p>
                                    <p>Account Created<br>
                                        <?=  date('d-M-Y',strtotime($row['accountCreated']))?>
                                    </p>
                                </div>
                            </div>
                            <div class="user-data">
                                <form action="code.php" method="post">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" value="<?= filter($row['name']); ?>" class="form-control" name='name' >
                                        <input type="hidden" value="<?= filter($row['id']); ?>" class="form-control"
                                            id="username" name="id">

                                    </div>
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" value="<?= filter($row['email']); ?>" class="form-control"
                                            id="email" name="email">
                                    </div>
                                    <div class="mb-3">
                                        <label for="coins" class="form-label">Coins</label>
                                        <input type="number" class="form-control" value="<?= filter($row['coins']); ?>"
                                            id="number" name="coins">
                                    </div>
                                    <div class="mb-3">
                                        <label for="coins" class="form-label">Total Coins</label>
                                        <input type="number" class="form-control"
                                            value="<?= filter($row['totalCoins']); ?>" id="number" name="totalcoins">
                                    </div>


                            </div>
                        </div>
                        <div class="d-felx-align-items-center flex-wrap">
                            <?php 
                            if ($row['isBanned'] == 0):
                                echo '<a href="code.php?banuser='.$user_id.'" class="btn btn-primary ban-user">Ban</a>';
                               
                            else:

echo '<a href="code.php?unbanuser='.$user_id.'" class="btn btn-primary unban-user">Unban</a>';

                            endif;
                        
                        ?>
                            

                            <button type="submit" name="save_user" class="btn btn-primary save-user-btn">Submit</button>
                        </div>
                        </form>
                        <?php
                    $uId = $row['uId'];
                    $name = $row['name'];
                     endforeach;
                    else:
                        echo "Some Error Occured";
                    endif;
                    
                    ?>
                    </div>
                </div>
                <div class="col-8">
                    <div class="user-table-data  user-table-data">
                        <div class="card-heading">
                            Withdraw Requests
                        </div>
                        <table id="example" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SR No.</th>
                                    <th>Name</th>

                                    <th>Method</th>
                                    <th>Method Id</th>
                                    <th>Amount</th>
                                    <th>Coins</th>
                                    <th>Status</th>
                                    <th>Request Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
            global $uId;
            global $name;
            $withreqsql = "SELECT * FROM `withdrawrequests` WHERE `uId`='$uId'";

            $query_runwithreqsql = mysqli_query($conn, $withreqsql);

            if ($query_runwithreqsql):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_runwithreqsql as $row):
                        if ($row['status'] == 0):
                            $text = "Paid";
                            $style = "active";
                        else:
                            $text = "Pending";
                            $style = "banned";
                        endif;
                        ?>



                                <tr id="box<?= $row['id']; ?>">

                                    <td>
                                        <?= $i; ?>
                                    </td>
                                    <td>
                                        <?= $name; ?>
                                    </td>

                                    <td>
                                        <?= $row['method'] ?>
                                    </td>
                                    <td>
                                        <?= $row['methodId'] ?>
                                    </td>
                                    <td>
                                        <?= $row['amount'] ?>
                                    </td>
                                    <td>
                                        <?= $row['coins'] ?>
                                    </td>

                                    <td class="d-flex align-items-center"><span class="<?= $style; ?>">
                                            <?= $text ?>
                                        </span></td>
                                    <td>
                                        <?=  date('d-M-Y',strtotime($row['requestTime']))?>
                                    </td>

                                </tr>


                                <?php

                        $i++;
                    endforeach;








                else:
                    echo "No User Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php 

        else:
            echo "Some error occured!";
        endif;


?>


            <div class="row g-3 my-4">


            <div class="col-6">
            <div class="user-table-data  user-table-data" style="overflow-x: scroll;">
                        <div class="card-heading">
                            Playing History
                        </div>
                        <table id="example2" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SR No.</th>
                                    <th>Name</th>
                                   
                                    <th>Activity</th>
                                    <th>Coins</th>
                                    <th>Type</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
            global $uId;
            global $name;
            $withreqsql = "SELECT * FROM `playinghistory` WHERE `uId`='$uId'";

            $query_runwithreqsql = mysqli_query($conn, $withreqsql);

            if ($query_runwithreqsql):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_runwithreqsql as $row):
                        if ($row['paid'] == 0):
                            $text = "+";
                            $style = "#1eb05a";
                        else:
                            $text = "-";
                            $style = "#ae1b1b";
                        endif;
                        ?>



                                <tr id="box<?= $row['id']; ?>">

                                    <td>
                                        <?= $i; ?>
                                    </td>
                                    <td>
                                        <?= $name; ?>
                                    </td>

                                    
                                    <td>
                                        <?= $row['activity'] ?>
                                    </td>
                                    <td style="color: <?= $style; ?>">
                                        <?= $text.$row['coins'] ?>
                                    </td>
                                    <td>
                                        <?= $row['type'] ?>
                                    </td>

                                    <td>
                                        <?=  date('d-M-Y',strtotime($row['date']))?>
                                    </td>

                                </tr>


                                <?php

                        $i++;
                    endforeach;








                else:
                    echo "No User Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                            </tbody>
                        </table>
                    </div>
            </div>
            <div class="col-6">
            <div class="user-table-data  user-table-data" style="overflow-x: scroll;">
                        <div class="card-heading">
                            Quiz History
                        </div>
                        <table id="example3" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th>SR No.</th>
                                    <th>Quiz Name</th>

                                    <th>Total Questions</th>
                                    <th>Question Attempted</th>
                                    <th>Correct Answers</th>
                                    <th>Wrong Answers</th>
                                    <th>Enry Fee</th>
                                    <th>Prize</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
            global $uId;
            global $name;
            $withreqsql = "SELECT * FROM `quizhistory` WHERE `uId`='$uId'";

            $query_runwithreqsql = mysqli_query($conn, $withreqsql);

            if ($query_runwithreqsql):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_runwithreqsql as $row):
                       
                        ?>



                                <tr id="box<?= $row['id']; ?>">

                                    <td>
                                        <?= $i; ?>
                                    </td>
                                    <td>
                                        <?= $row['quizName']; ?>
                                    </td>

                                    <td>
                                        <?= $row['totalQuestions'] ?>
                                    </td>
                                    <td>
                                        <?= $row['questionAttempted'] ?>
                                    </td>
                                    <td>
                                        <?= $row['correctAnswers'] ?>
                                    </td>
                                    <td>
                                        <?= $row['wrongAnswers'] ?>
                                    </td>
                                    <td>
                                        <?= $row['entryFee'] ?>
                                    </td>
                                    <td>
                                        <?= $row['prize'] ?>
                                    </td>

                                    <td>
                                        <?=  date('d-M-Y',strtotime($row['date']))?>
                                    </td>

                                </tr>


                                <?php

                        $i++;
                    endforeach;








                else:
                    echo "No User Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                            </tbody>
                        </table>
                    </div>
            </div>






            </div>



        </div>


    </div>
</main>





<?php 

include("includes/script.php");

?>



<script>
    $(document).ready(function () {
        $("#example").DataTable();
    });
    $(document).ready(function () {
        $("#example2").DataTable();
    });
    $(document).ready(function () {
        $("#example3").DataTable();
    });
</script>


<?php

include("includes/footer.php");


?>